//
//  MCStageSyncInitialize.h
//  MCStageSync
//
//  Created by Mark Onyschuk on 28/04/08.
//  Copyright 2008 Marketcircle, Inc.. All rights reserved.
//

#import "MCStageSyncOperation.h"

#import <MCFoundation/MCPDatabaseConnection.h>


@class MCPDatabaseObjectContext, MCPDatabaseConnection;

@interface MCStageSyncInitialize : MCStageSyncOperation {
	unsigned increments;
	int currentIncrement;
	NSDate *lastNotificationSentDate;
	NSNumber *offsetKey;
@private
	MCPDatabaseObjectContext *objectContext; // weak
	MCPDatabaseConnection *connection; // weak
	
	BDQualifier *trashQualifier;
}

@property (retain) NSNumber *offsetKey;

- (id)run;

@end


@interface MCPDatabaseConnection (MCStageSyncAdditions)

- (BOOL)MC_processSQLCommand:(NSString *)sql;
- (BOOL)MC_createTemporaryTableNamed:(NSString *)name;
- (BOOL)MC_deleteTemporaryTableNamed:(NSString *)name;
- (BOOL)MC_insertRawRow:(NSDictionary *)row inTableNamed:(NSString *)name;
- (BOOL)MC_insertAttributes:(NSArray *)attributes
				 fromObjects:(NSArray *)objects
			withStaticValues:(NSArray *)values
				  forColumns:(NSArray *)columns
			  intoTableNamed:(NSString *)name;
@end
